<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ricerca Paziente</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }

        .navbar {
            background-color: #007BFF;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .navbar a {
            float: left;
            display: block;
            color: white;
            text-align: center;
            padding: 14px 20px;
            text-decoration: none;
            transition: background-color 0.3s;
        }

        .navbar a:hover {
            background-color: #0056b3;
        }

        .container {
            max-width: 600px;
            margin: 20px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
            color: #333;
        }

        form {
            display: flex;
            flex-direction: column;
        }

        label {
            margin: 10px 0 5px;
            color: #555;
        }

        input {
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 16px;
        }

        input[type="submit"] {
            background-color: #007BFF;
            color: white;
            border: none;
            cursor: pointer;
            font-size: 18px;
            transition: background-color 0.3s;
        }

        input[type="submit"]:hover {
            background-color: #0056b3;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        table, th, td {
            border: 1px solid #ddd;
        }

        th, td {
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #007BFF;
            color: white;
        }

        @media (max-width: 600px) {
            .container {
                margin: 10px;
                padding: 15px;
            }

            input {
                font-size: 14px;
            }

            input[type="submit"] {
                font-size: 16px;
            }

            .navbar a {
                float: none;
                width: 100%;
                text-align: left;
                padding: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="navbar">
        <a href="inserisci_paziente.php">Inserisci Paziente</a>
        <a href="ricerca.php">Ricerca</a>
        
    </div>

    <div class="container" id="ricerca">
        <h1>Ricerca Paziente</h1>
        <form action="ricerca_paziente.php" method="GET">
            <label for="nome_assistito">Nome Assistito:</label>
            <input type="text" id="nome_assistito" name="nome_assistito">
            <input type="submit" value="Cerca">
        </form>

        <div id="risultati">
            <!-- I risultati della ricerca verranno mostrati qui -->
            <?php
            if (isset($_GET['nome_assistito']) && !empty($_GET['nome_assistito'])) {
                $servername = "localhost";
                $username = "root";
                $password = "";
                $dbname = "nome_database"; // Cambia con il nome del tuo database

                $conn = new mysqli($servername, $username, $password, $dbname);

                if ($conn->connect_error) {
                    die("Connessione fallita: " . $conn->connect_error);
                }

                $nome_assistito = $conn->real_escape_string($_GET['nome_assistito']);
                $sql = "SELECT * FROM PAZIENTE WHERE assistito LIKE '%$nome_assistito%'";
                $result = $conn->query($sql);

                if ($result->num_rows > 0) {
                    echo "<table>";
                    echo "<tr><th>ID</th><th>Tipo Servizio</th><th>Data Servizio</th><th>Assistito</th><th>Partenza da</th><th>Arrivo a</th><th>Telefono</th><th>Tipo Equipaggio</th><th>Importo</th><th>Annotazioni</th></tr>";

                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . $row["id"] . "</td>";
                        echo "<td>" . $row["tipo_servizio"] . "</td>";
                        echo "<td>" . $row["data_servizio"] . "</td>";
                        echo "<td>" . $row["assistito"] . "</td>";
                        echo "<td>" . $row["partenza_da"] . "</td>";
                        echo "<td>" . $row["arrivo_a"] . "</td>";
                        echo "<td>" . $row["telefono"] . "</td>";
                        echo "<td>" . $row["tipo_equipaggio"] . "</td>";
                        echo "<td>" . $row["importo"] . "</td>";
                        echo "<td>" . $row["annotazioni"] . "</td>";
                        echo "</tr>";
                    }
                    echo "</table>";
                } else {
                    echo "<p>Nessun risultato trovato</p>";
                }

                $conn->close();
            }
            ?>
        </div>
    </div>
</body>
</html>
