<!DOCTYPE html>
<html lang="it">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrazione Paziente</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }

        .container {
            max-width: 600px;
            margin: 20px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
            color: #333;
        }

        nav {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }

        nav button {
            background-color: #007BFF;
            color: white;
            border: none;
            padding: 10px 20px;
            margin: 5px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }

        nav button:hover {
            background-color: #0056b3;
        }

        form {
            display: flex;
            flex-direction: column;
        }

        label {
            margin: 10px 0 5px;
            color: #555;
        }

        input, select, textarea {
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 16px;
        }

        input[type="submit"] {
            background-color: #007BFF;
            color: white;
            border: none;
            cursor: pointer;
            font-size: 18px;
            transition: background-color 0.3s;
        }

        input[type="submit"]:hover {
            background-color: #0056b3;
        }

        @media (max-width: 600px) {
            .container {
                margin: 10px;
                padding: 15px;
            }

            nav {
                flex-direction: column;
            }

            input, select, textarea {
                font-size: 14px;
            }

            input[type="submit"] {
                font-size: 16px;
            }

            nav button {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Registrazione Paziente</h1>
      <div class="navbar">
        <a href="inserisci_paziente.php">Inserisci Paziente</a>
        <a href="ricerca.php">Ricerca</a>
        
    </div>
        <form action="inserisci_paziente.php" method="POST">
            <label for="tipo_servizio">Tipo di Servizio:</label>
            <select id="tipo_servizio" name="tipo_servizio" required>
                <option value="privato">Privato</option>
                <option value="clinica">Clinica</option>
            </select>

            <label for="data_servizio">Data Servizio:</label>
            <input type="date" id="data_servizio" name="data_servizio" required>

            <label for="assistito">Assistito:</label>
            <input type="text" id="assistito" name="assistito" required>

            <label for="partenza_da">Partenza da:</label>
            <input type="text" id="partenza_da" name="partenza_da" required>

            <label for="arrivo_a">Arrivo a:</label>
            <input type="text" id="arrivo_a" name="arrivo_a" required>

            <label for="telefono">Telefono:</label>
            <input type="tel" id="telefono" name="telefono" required>

            <label for="tipo_equipaggio">Tipo di Equipaggio:</label>
            <input type="text" id="tipo_equipaggio" name="tipo_equipaggio" required>

            <label for="importo">Importo:</label>
            <input type="number" step="0.01" id="importo" name="importo" required>

            <label for="annotazioni">Annotazioni:</label>
            <textarea id="annotazioni" name="annotazioni"></textarea>

            <input type="submit" value="Registra Paziente">
        </form>
    </div>
</body>
</html>
